<?
/*
* Klasa do obsługi Produktów
*/
include_once './php/klasy/drzewko.php';
class Produkty extends drzewko
{
	const tabela = 'products2';
	const p = 16;

	function cropImage($source, $dest,$nw,$nh) {
		$size = getimagesize($source);
		$w = $size[0];
		$h = $size[1];
		switch(mime_content_type($source)) {
			case 'image/gif':
				$simg = imagecreatefromgif($source);
				break;
			case 'image/jpg': case 'image/jpeg':
				$simg = imagecreatefromjpeg($source);
				break;
			case 'image/png':
				$simg = imagecreatefrompng($source);
				break;
		}
		$dimg = imagecreatetruecolor($nw, $nh);

		$white = imagecolorallocate($dimg, 255, 255, 255);
		imagefill($dimg, 0, 0, $white);
		$wm = $w/$nw;
		$hm = $h/$nh;
		$h_height = $nh/2;
		$w_height = $nw/2;
		if($w> $h) {
			$adjusted_width = $w / $hm;
			$half_width = $adjusted_width / 2;
			$int_width = $half_width - $w_height;
			imagecopyresampled($dimg,$simg,-$int_width,0,0,0,$adjusted_width,$nh,$w,$h);
		} elseif(($w <$h) || ($w == $h)) {
			$adjusted_height = $h / $wm;
			$half_height = $adjusted_height / 2;
			$int_height = $half_height - $h_height;
			imagecopyresampled($dimg,$simg,0,-$int_height,0,0,$nw,$adjusted_height,$w,$h);
		} else {
			imagecopyresampled($dimg,$simg,0,0,0,0,$nw,$nh,$w,$h);
		}

		switch(mime_content_type($source)) {
			case 'image/gif':
				$result 	=	imagegif($dimg,$dest);
				break;
			case 'image/jpg': case 'image/jpeg':
				$result 	=	imagejpeg($dimg,$dest,100);
				break;
			case 'image/png':
				$result 	=	imagepng($dimg,$dest,100);
				break;
		}
		
		return $result;
	}

	public function form($akcja= 'dodaj', $tab = null)
	{
		$new = new generatorFormularzy('Produkt','./index.php?p='.self::p.'&a=2','POST','enctype="multipart/form-data"',true);
		$new->poczatekForm();

		$new->inupt('Nazwa', 'text',!empty($tab['nazwa']) ? $tab['nazwa'] : '','','textlong');

		$new->text('<br />');
		if(is_file('../galeria/min/'.$tab['zdjecie'])){
			$new->text('<center><img src="../galeria/min/'.$tab['zdjecie'].'" border="0" alt="logo" title="logo" /></center>');
		}
		$new->select('kategoria', $this->displayTreeSelect(), !empty($tab['kategoria']) ? $tab['kategoria'] : '', '', true, 'Wybierz kategorię');

		$new->text('<br />');
		$new->textarea('Treść', 20, 80,'',stripslashes($tab['opis']),'textlong');

		$new->inupt('r', 'hidden',time(),'','',false);
		$new->inupt('akcja', 'hidden',$akcja,'','',false);

		if(isset($_GET['nr']))
		$new->inupt('id', 'hidden',$_GET['nr'],'','',false);

		$new->inupt('ok', 'submit',ucfirst($akcja),'','searchbutton',false);
		$new->text('<br />');
		$new->koniecForm();
	}


	public function menu()
	{
		$smarty = Zend_Registry::get('smarty');

		$submenu[0]['link'] = '?p='.self::p.'&a=1';
		$submenu[0]['tekst'] = 'Dodaj nowy';

		$smarty->assign('submenu', $submenu);
		$smarty->assign('lista',$this->lista());
	}

	public function add()
	{
		try
		{
			$smarty = Zend_Registry::get('smarty');

			Zend_Loader::loadClass('Zend_Filter_StripTags');
			$filtr = new Zend_Filter_StripTags();

			if(isset($_SESSION['form']) && $_SESSION['form']==$_POST['r'])
			throw new Exception('Nie odświeżaj strony!');

			$_SESSION['form'] = $_POST['r'];

			$data = array();

			$data['nazwa'] 		= 	$filtr->filter($_POST['nazwa']);
			$data['opis'] 		= 	$_POST['tresc'];
			$data['kategoria'] 		= 	(int)$_POST['kategoria'];

			$db = Zend_Registry::get('db');

			if($_POST['akcja']=='dodaj')
			{
				$db->insert(Index::dbPrefiks.self::tabela, $data);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Dodano prawidłowo.'));
				$this->menu();
			}
			else
			{
				$db->update(Index::dbPrefiks.self::tabela,$data, 'id='.(int)$_POST['id']);
				$smarty->assign('komunikat', array('typ' => 'info', 'tekst' => 'Dane zostały zmienione prawidłowo.'));
				$this->menu();
			}
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}

	public function lista()
	{
		try
		{
			$sql = "
			SELECT p.*,c.nazwa_pl as knazwa
			FROM ".Index::dbPrefiks.self::tabela." p
			LEFT JOIN ".Index::dbPrefiks."drzewko c on p.kategoria = c.id
			ORDER BY p.id ASC";

			$db = Zend_Registry::get('db');

			return $db->fetchAll($sql);
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function delete($id)
	{
		try
		{
			if(empty($id))
			{
				throw new Exception('Brak identyfikatora.');
			}

			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');
			$sql = 'select * from '.Index::dbPrefiks.self::tabela.' where id='.(int)$id;

			$plik = $db->fetchRow($sql);

			$db->delete(Index::dbPrefiks.self::tabela,'id='.(int)$id);

			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> '<b>'.$plik['nazwa'].'</b> został poprawnie usuniety.'));
			$this->menu();
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function visible($id)
	{
		try
		{
			if(empty($id))
			{
				throw new Exception('Brak identyfikatora.');
			}

			$db = Zend_Registry::get('db');
			$smarty = Zend_Registry::get('smarty');
			$sql = 'select * from '.Index::dbPrefiks.self::tabela.' where id='.(int)$id;

			$plik = $db->fetchRow($sql);

			switch ($plik['aktywny']){
				case 'tak':
					$active = 'nie';
					break;
				default:
					$active = 'tak';
					break;
			}

			$db->update(Index::dbPrefiks.self::tabela,array('aktywny'=>$active),'id='.(int)$id);

			$smarty->assign('komunikat', array('typ'=>'info', 'tekst'=> '<b>'.$plik['nazwa'].'</b> został poprawnie zmieniony.'));
			$this->menu();
		}
		catch (Zend_Db_Adapter_Exception $error)
		{
			Index::przechwyc_blad($error);
		}

		catch (Zend_Exception $error)
		{
			Index::przechwyc_blad($error);
		}
	}

	public function edit()
	{
		try
		{
			if(!isset($_GET['nr']) || empty($_GET['nr']))
			throw new Exception('Blad przy edycji!');

			$sql="SELECT * FROM ".Index::dbPrefiks.self::tabela." WHERE id=".(int)$_GET['nr'];

			$db = Zend_Registry::get('db');
			$this->form('edycja',$db->fetchRow($sql));
		}

		catch (Zend_Db_Adapter_Exception $e)
		{
			Index::przechwyc_blad($e);
		}

		catch (Zend_Exception $e)
		{
			Index::przechwyc_blad($e);
		}
	}
}
?>