<?php
header('Content-Type: text/html; charset=utf-8');
echo "<!-- e067d8c3f507f6e50f701402c8a61278 -->";//rozpoznawanie proxy

Class GooglePR {

	//Public vars
	var $googleDomains = Array("toolbarqueries.google.com");
	
	var $debugResult = Array();
	var $userAgent = "Mozilla/5.0 (X11; U; Linux i686; en-US; rv:1.2.1) Gecko/20021204";
	var $cacheDir = "/tmp";
	var $maxCacheAge = 86400; // = 24h (yes, in seconds)
	var $useCache = false;
	var $debug = false;

	//Private vars
	var $PageRank = -1;
	var $cacheExpired = false;


	function GetPR($url, $useragent, $interface = false, $forceNoCache = false) {
		$total_exec_start = $this->microtimeFloat();
		$result=array("",-1);

		if (($url.""!="")&&($url.""!="http://")) {

			$this->debugRes("url", $url);

			$this->cacheDir .= (substr($this->cacheDir,-1) != "/")? "/":"";

			// check for protocol
			$url_ = ((substr(strtolower($url),0,7)!="http://")? "http://".$url:$url);
			$host = $this->googleDomains[mt_rand(0,count($this->googleDomains)-1)];
			$target = "/search";
			$querystring = sprintf("client=navclient-auto&ch=%s&features=Rank&q=%s",
				$this->CheckHash($this->HashURL($url_)),urlencode("info:".$url_));
			$contents="";

			$this->debugRes("host", $host);
			$this->debugRes("query_string", $querystring);
			$this->debugRes("user_agent", $this->userAgent);

			$query_exec_start = $this->microtimeFloat();

			if ($forceNoCache == true) {
				$this->debugRes("force_no_cache", "true");
			} elseif ($contents = $this->readCacheResult($url)) {
				$this->debugRes("read_from_cache", "true");
			} else {
				$this->cacheExpired = true;
			}


			// let's get ranking
			if (strlen(trim($contents)) == 0)
			if (@function_exists("curl_init")) {
			
				// allways use curl if available for performance issues
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, "http://".$host.$target."?".$querystring);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                                
                                if ($interface != false)
                                    curl_setopt($ch, CURLOPT_INTERFACE, $interface);

				curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_0);
                                curl_setopt($ch, CURLOPT_USERAGENT, $useragent);

				if (!($contents = trim(@curl_exec($ch)))) {
					$this->debugRes("error","curl_exec failed");
				}
				curl_close ($ch);
				$this->debugRes("method", "curl");

			} else {
				$this->debugRes("error","curl not installed, trying to use fsockopen");
				// use fsockopen as secondary method, to submit user agent
				if ($socket  = @fsockopen($host, "80", $errno, $errstr, 30)) {

					$request  = "GET $target?$querystring HTTP/1.0\r\n";
					$request .= "Host: $host\r\n";
					$request .= "User-Agent: ".$useragent."\r\n";
					$request .= "Accept-Language: en-us, en;q=0.50\r\n";
					$request .= "Accept-Charset: ISO-8859-1, utf-8;q=0.66, *;q=0.66\r\n";
					$request .= "Accept: text/xml,application/xml,application/xhtml+xml,";
					$request .= "text/html;q=0.9,text/plain;q=0.8,video/x-mng,image/png,";
					$request .= "image/jpeg,image/gif;q=0.2,text/css,*/*;q=0.1\r\n";
					$request .= "Connection: close\r\n";
					$request .= "Cache-Control: max-age=0\r\n\r\n";

					stream_set_timeout ( $socket,10);
					fwrite( $socket, $request );
					$ret = '';
					while (!feof($socket)) {
						$ret .= fread($socket,4096);
					}
					fclose($socket);
					$contents = trim(substr($ret,strpos($ret,"\r\n\r\n") + 4));
					$this->debugRes("method", "fsockopen");
				} else {
					$this->debugRes("error","fsockopen failed, trying file_get_contents");
					// this way could cause problems because the Browser Useragent is not set...
					if ($contents = trim(@file_get_contents("http://".$host.$target."?".$querystring))) {
						$this->debugRes("method", "file_get_contents");
					} else {
						$this->debugRes("error","file_get_contents failed");
					}
				}

			}

			if ($this->cacheExpired == true)
			$this->updateCacheResult($url,$contents);

			$this->debugRes("query_exec_time",$this->microtimeFloat() - $query_exec_start);
                      
			if(strpos($contents, '<H1>302 Moved</H1>') !== FALSE){
                            $result[1] = -2;
                        }else{
                            $result[0]=$contents;
                            // Rank_1:1:0 = 0
                            // Rank_1:1:5 = 5
                            // Rank_1:1:9 = 9
                            // Rank_1:2:10 = 10 etc
                            $p=explode(":",$contents);
                            if (isset($p[2]))
                            $result[1]=$p[2];
                            else
                            $result[1] = -1;
                        }
		}

		
		$this->PageRank =(int)$result[1];
		$this->debugRes("total_exec_time", $this->microtimeFloat() - $total_exec_start);
		$this->debugRes("result", $result);
       
		return $this->PageRank;

	}


	function debugRes($what,$sowhat) {
		if($this->debug == true) {
			$debugbt = debug_backtrace();
			$what = trim($what);
			$sowhat = trim($sowhat) . " (Line : ".$debugbt[0]["line"].")";
			if ($what == "error") {
				$this->debugResult[$what][] = $sowhat;
			} else {
				$this->debugResult[$what] = $sowhat;
			}
		}
	}

	function microtimeFloat() {
		list($usec, $sec) = explode(" ", microtime());
		return ((float)$usec + (float)$sec);
	}


	function readCacheResult($url) {
		if ($this->useCache != true) {
			return false;
		}

		if (!is_dir($this->cacheDir)) {
			$this->debugRes("error","please create {$this->cacheDir}");
			return false;
		}

		$urlp = parse_url($url);
		$host_ = explode(".",$urlp["host"]);
		$path_ = (strlen($urlp["query"])>0)? urlencode($urlp["path"].$urlp["query"]):"default";

		$cache_file = $this->cacheDir;

		for ($i = count($host_)-1;$i>=0;$i--) {
			$cache_file .= $host_[$i]."/";
		}

		$cache_file .= $path_;
		$this->debugRes("cache_file", $cache_file);
		if (file_exists($cache_file)) {
			$mtime = filemtime($cache_file);
			if (time() - $mtime > $this->maxCacheAge) {
				$this->debugRes("cache", "expired");
				$this->cacheExpired = true;
				return false;
			} else {
				$this->cacheExpired = false;
				$this->debugRes("cache_age", time() - $mtime);
				return file_get_contents($cache_file);
			}
		}
		$this->debugRes("error","cache file not exists (reading)");
		return false;
	}

	function updateCacheResult($url,$content) {
		if ($this->useCache != true) {
			return false;
		}

		if (!is_dir($this->cacheDir)) {
			$this->debugRes("error","please create {$this->cacheDir}");
			return false;
		}

		$urlp = parse_url($url);
		$host_ = explode(".",$urlp["host"]);
		$path_ = (strlen($urlp["query"])>0)? urlencode($urlp["path"].$urlp["query"]):"default";

		$cache_file = $this->cacheDir;
		for ($i = count($host_)-1;$i>=0;$i--) {
			$cache_file .= $host_[$i]."/";
		}

		$cache_file .= $path_;

		if (!file_exists($cache_file)) {
			$this->debugRes("error","cache file not exists (writing)");
			$cache_file_tmp = substr($cache_file,strlen($this->cacheDir));
			$cache_file_tmp = explode("/",$cache_file_tmp);
			$cache_dir_ = $this->cacheDir;
			for ($i = 0;$i<count($cache_file_tmp)-1;$i++) {
				$cache_dir_ .= $cache_file_tmp[$i]."/";
				if (!file_exists($cache_dir_)) {
					if (!@mkdir($cache_dir_,0777)) {
						$this->debugRes("error","unable to create cache dir: $cache_dir_");
						//break;
					}
				}
			}
			if (!@touch($cache_file)) $this->debugRes("error","unable to create cache file");
			if (!@chmod($cache_file,0777)) $this->debugRes("error","unable to chmod cache file");
		}

		if (is_writable($cache_file)) {
			if (!$handle = fopen($cache_file, 'w')) {
				$this->debugRes("error", "unable to open $cache_file");
				return false;
			}
			if (fwrite($handle, $content) === FALSE) {
				$this->debugRes("error", "unable to write to $cache_file");
				return false;
			}
			fclose($handle);
			$this->debugRes("cached", date("Y-m-d H:i:s"));
			return true;
		}
		$this->debugRes("error", "$cache_file is not writable");
		return false;

	}

	//convert a string to a 32-bit integer
	function StrToNum($Str, $Check, $Magic) {
		$Int32Unit = 4294967296;  // 2^32
		$length = strlen($Str);
		for ($i = 0; $i < $length; $i++) {
			$Check *= $Magic; 	
			//If the float is beyond the boundaries of integer (usually +/- 2.15e+9 = 2^31), 
			//  the result of converting to integer is undefined
			//  refer to http://www.php.net/manual/en/language.types.integer.php
			if ($Check >= $Int32Unit) {
				$Check = ($Check - $Int32Unit * (int) ($Check / $Int32Unit));
				//if the check less than -2^31
				$Check = ($Check < -2147483648) ? ($Check + $Int32Unit) : $Check;
			}
			$Check += ord($Str{$i}); 
		}
		return $Check;
	}

	//genearate a hash for a url
	function HashURL($String) {
		$Check1 = $this->StrToNum($String, 0x1505, 0x21);
		$Check2 = $this->StrToNum($String, 0, 0x1003F);
		$Check1 >>= 2; 	
		$Check1 = (($Check1 >> 4) & 0x3FFFFC0 ) | ($Check1 & 0x3F);
		$Check1 = (($Check1 >> 4) & 0x3FFC00 ) | ($Check1 & 0x3FF);
		$Check1 = (($Check1 >> 4) & 0x3C000 ) | ($Check1 & 0x3FFF);	
		
		$T1 = (((($Check1 & 0x3C0) << 4) | ($Check1 & 0x3C)) <<2 ) | ($Check2 & 0xF0F );
		$T2 = (((($Check1 & 0xFFFFC000) << 4) | ($Check1 & 0x3C00)) << 0xA) | ($Check2 & 0xF0F0000 );
		
		return ($T1 | $T2);
	}
	
	//genearate a checksum for the hash string
	function CheckHash($Hashnum) {
		$CheckByte = 0;
		$Flag = 0;
		$HashStr = sprintf('%u', $Hashnum) ;
		$length = strlen($HashStr);
		
		for ($i = $length - 1;  $i >= 0;  $i --) {
			$Re = $HashStr{$i};
			if (1 === ($Flag % 2)) {			  
				$Re += $Re;	 
				$Re = (int)($Re / 10) + ($Re % 10);
			}
			$CheckByte += $Re;
			$Flag ++;	
		}
	
		$CheckByte %= 10;
		if (0 !== $CheckByte) {
			$CheckByte = 10 - $CheckByte;
			if (1 === ($Flag % 2) ) {
				if (1 === ($CheckByte % 2)) {
					$CheckByte += 9;
				}
				$CheckByte >>= 1;
			}
		}
		return '7'.$CheckByte.$HashStr;
	}
}

function parse_cookies($request){
    preg_match_all("/Set-Cookie: (.*)/", $request, $cookies);
    $jar = '';

    if(is_array($cookies[1])){
        foreach($cookies[1] as $value){
            $jar .= $value;
        }
    }

return $jar;
}

function get_location_cookie($loc_name, $loc_64){
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_HEADER, 1);
    curl_setopt($curl, CURLOPT_ENCODING, "UTF-8" );
    curl_setopt($curl, CURLOPT_URL, 'http://www.google.pl/preferences');
    $google_settings = curl_exec($curl);
    curl_close($curl);

    $cookies_jar = parse_cookies($google_settings);

    $regEx = '/<input type="hidden" name="sig" value="(.*)=">/';
    preg_match($regEx, $google_settings, $sigs);
    $sig = $sigs[1];

    $regEx = '/<input type="?hidden"? name="?muul"? value="?([0-9_]*)"?>/';
    preg_match($regEx, $google_settings, $muuls);
    $muul = $muuls[1];

    $regEx = '/<input type="?hidden"? name="?uulo"? value="?([0-9_]*)"?>/';
    preg_match($regEx, $google_settings, $uulos);
    $uulo = $uulos[1];

    $set_loc_url = 'http://www.google.pl/uul?muul='.$muul.'&luul='.$loc_name.'&usg='.$sig.'=&uulo='.$uulo.'&hl=pl';

    $curl = curl_init();
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_HEADER, 1);
    curl_setopt($curl, CURLOPT_COOKIE, $cookies_jar);
    curl_setopt($curl, CURLOPT_ENCODING, "UTF-8" );
    curl_setopt($curl, CURLOPT_URL, $set_loc_url);
    $google_set_loc = curl_exec($curl);
    curl_close($curl);


    if(strpos($google_set_loc, 'rozpoznano lokalizacji') !== FALSE OR strpos($google_set_loc, 'Bad Request') !== FALSE){
        $output = FALSE;
    }else{
        $output = parse_cookies($google_set_loc);
    }

    return $output;

}

if($_POST){
    $log .= "PROXY otrzymalo dane POST: ".print_r($_POST, true)." \n";

    if($_POST['google'] AND substr($_POST['google'], 0, 4) != "www.")
        $_POST['google'] = "www.".$_POST['google'];


    if($_POST['key'] == "SYSTEM_SITECHECK" AND $_POST['google'] AND $_POST['site_url']){
        $log .= "Przeprowadzone bedzie sprawdzanie SITE \n";

        $url = trim($_POST['site_url']);

        if($_POST['google'])
            $google_domain = $_POST['google'];
        else
            $google_domain = "www.google.pl";



        if($_POST['lr'])
            $lr = $_POST['lr'];
        else
            $lr = "";

        $googleURL='http://'.$google_domain.'/search?q=site%3A'.$url.'&ie=utf8&lr='.$lr.'&hl=en';

        $log .= "Inicjuje polaczenie cURL pobierajace URL: ".$googleURL." \n";

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_URL, $googleURL);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        if($_POST['interface']){
            $log .= "Ustawiam CURLOPT_INTERAFCE: ".$_POST['interface']." \n";
            curl_setopt($curl, CURLOPT_INTERFACE, $_POST['interface']);
        }
        curl_setopt($curl, CURLOPT_REFERER, 'www.google.pl');
        $google = curl_exec($curl);

        $curl_errno = curl_errno($curl);
        curl_close($curl);

        $log .= "Wartosc curl_errno: ".$curl_errno." \n";


        if($curl_errno != 0){
           $log .= "Wystapil blad - curl_errno != 0: HTTP_PROXY_ERROR \n";
        }else{
           $log .= "cURL zwrocil: ".$google." \n";
        }




    }elseif($_POST['key'] == "SYSTEM_LINKCHECK" AND $_POST['site_url'] AND isset($_POST['entire_site'])){
        $log .= "Przeprowadzone bedzie sprawdzanie BL \n";

        $url = trim($_POST['site_url']);

        if($_POST['entire_site'] == 1)
            $yahooURL='http://siteexplorer.search.yahoo.com/advsearch?p='.$url.'&bwm=i&bwmo=d&bwmf=s';
        else
            $yahooURL='http://siteexplorer.search.yahoo.com/advsearch?p='.$url.'&bwm=i&bwmo=d&bwmf=u';

        $log .= "Inicjuje polaczenie cURL pobierajace URL: ".$yahooURL." \n";

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_URL, $yahooURL);

        if($_POST['interface']){
            $log .= "Ustawiam CURLOPT_INTERAFCE: ".$_POST['interface']." \n";
            curl_setopt($curl, CURLOPT_INTERFACE, $_POST['interface']);
        }

        curl_setopt($curl, CURLOPT_REFERER, 'www.yahoo.com');
        $yahoo = curl_exec($curl);
        $curl_errno = curl_errno($curl);
        curl_close($curl);

        $log .= "Wartosc curl_errno: ".$curl_errno." \n";

        if($curl_errno != 0)
           $log .= "Wystapil blad - curl_errno != 0: HTTP_PROXY_ERROR \n";
        else
           $log .= "cURL zwrocil: ".$yahoo." \n";


    }elseif($_POST['key'] == "SYSTEM_PRCHECK" AND $_POST['site_url']){
        $log .= "Przeprowadzone bedzie sprawdzanie PR \n";
        
        if(!$_POST['interface'] OR $_POST['interface'] == '0')
            $_POST['interface'] = false;
        else
            $log .= "Ustawiam CURLOPT_INTERAFCE: ".$_POST['interface']." \n";

        if($_POST['useragent'])
            $useragent = $_POST['useragent'];
        else
            $useragent = "Mozilla/5.0 (Windows; U; Windows NT 5.1; pl; rv:1.9.2.12) Gecko/20101026 Firefox/3.6.12";

        $log .= "Inicjuje nowy obiekt klasy GooglePR \n";

        $url = trim($_POST['site_url']);
        $pr = new GooglePR();

        $google_pr = $pr->GetPR('http://'.$url, $useragent, $_POST['interface']);
        $log .= "Pobrano wartosc PR: <google_pr>".$google_pr."</google_pr> \n";


    }elseif ($_POST['site_url'] AND $_POST['key'] AND $_POST['google'] AND $_POST['google_check']){
        $log .= "Przeprowadzone bedzie sprawdzanie GOOGLE RANK \n";

        $url = trim($_POST['site_url']);
        $keyword = $_POST['key'];
        $google_check = $_POST['google_check'];

        if($_POST['google'])
            $google_domain = $_POST['google'];
        else
            $google_domain = "www.google.pl";

        if($_POST['hl'])
            $hl = $_POST['hl'];
        else
            $hl = "pl";

        if($_POST['lr'])
            $lr = $_POST['lr'];
        else
            $lr = "";

        if($_POST['useragent'])
            $useragent = $_POST['useragent'];
        else
            $useragent = "Mozilla/5.0 (Windows; U; Windows NT 5.1; pl; rv:1.9.2.12) Gecko/20101026 Firefox/3.6.12";


        if(is_numeric($_POST['start']))
            $start = $_POST['start'];
        else
            $start = 0;


        if($_POST['location_name'] AND $_POST['location_64']){
            $log .= "Wymuszam lokalizacje: ".$_POST['location_name']." \n";

            $location['name'] = $_POST['location_name'];
            $location['64'] = $_POST['location_64'];
            $location['cookie'] = $_POST['location_cookie'];

            if(!$location['cookie']){
                $log .= "Brak pliku COOKIE w tablicy POST - pobieram wlasciwe COOKIE \n";

                $location_cookie = get_location_cookie($location['name'], $location['64']);
                if($location_cookie AND strlen($location_cookie) > 2){
                    $log .= "Pobrano COOKIE: <location_cookie>".$location_cookie."</location_cookie> \n";
                    $location['cookie'] = $location_cookie;
                }else
                $log .= "Nie udalo sie pobrac COOKIE: ".$location_cookie." \n";
            }else
                $log .= "Cookie lokalizacji zostalo wyslane w POST: ".$location['cookie']." \n";
        }

        if(isset($_POST['start']) AND $_POST['start'] != '999')
            $googleURL = 'http://'.$google_domain.'/search?q='.$keyword.'&num=10&start='.$start.'&ie=utf8&hl='.$hl.'&lr='.$lr.'';
        else
            $googleURL = 'http://'.$google_domain.'/search?q='.$keyword.'&num='.$google_check.'&ie=utf8&hl='.$hl.'&lr='.$lr.'';

        $log .= "Inicjuje polaczenie cURL pobierajace URL: ".$googleURL." \n";

        $curl = curl_init();
        curl_setopt($curl, CURLOPT_HEADER, 0);
        if($location['cookie']){
            $log .= "Ustawiam COOKIE: ".$location['cookie']." \n";
            curl_setopt($curl, CURLOPT_COOKIE, $location['cookie']);
        }
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_VERBOSE, 0);
        curl_setopt($curl, CURLOPT_USERAGENT, $useragent);
        curl_setopt($curl, CURLOPT_REFERER, 'www.google.pl');
        curl_setopt($curl, CURLOPT_URL, $googleURL);

        if($_POST['interface']){
            $log .= "Ustawiam CURLOPT_INTERAFCE: ".$_POST['interface']." \n";
            curl_setopt($curl, CURLOPT_INTERFACE, $_POST['interface']);
        }

        $google = curl_exec($curl);
        $curl_errno = curl_errno($curl);
        curl_close($curl);

        $log .= "Wartosc curl_errno: ".$curl_errno." \n";

        if($curl_errno != 0)
           $log .= "Wystapil blad - curl_errno != 0: HTTP_PROXY_ERROR \n";
        else
           $log .= "cURL zwrocil: ".$google." \n";

    }

    echo $log;

}else{

    $googleURL = 'http://www.google.pl/search?q=google&num=10&start=0&ie=utf8&hl=en';
    $curl = curl_init();
    curl_setopt($curl, CURLOPT_HEADER, 0);
    curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($curl, CURLOPT_VERBOSE, 0);

    if($_GET['interface'])
        curl_setopt($curl, CURLOPT_INTERFACE, $_GET['interface']);

    curl_setopt($curl, CURLOPT_USERAGENT, "Mozilla/5.0 (Windows; U; Windows NT 5.1; pl; rv:1.9.2.12) Gecko/20101026 Firefox/3.6.12");
    curl_setopt($curl, CURLOPT_REFERER, 'www.google.pl');
    curl_setopt($curl, CURLOPT_URL, $googleURL);
    $google = curl_exec($curl);

    if($_GET['interface'])
        $curl_errno = curl_errno($curl);

    curl_close($curl);

    echo "Curl: ";
    if(curl_init() AND $curl_errno == 0)
        echo "<b>Ok</b>;<br/>";
    else
        if($curl_errno == 7)
            echo "<b>Błąd interfejsu - podaj poprawne IP</b>;<br/>";
        else
            echo "<b>Błąd biblioteki cURL [".$curl_errno."]</b>;<br/>";

    echo "Odpytywanie Google: ";

    if(strpos($google, '<H1>302 Moved</H1>') !== FALSE)
        echo "<b>Błąd - IP zbanowane</b><br/>";
    else
        echo "<b>Ok</b><br/>";

}
?>