<?php
session_start();

define ('PREFIKS', 'cms_');
class Index
{
	const dbPrefiks = PREFIKS;

	public function __construct()
	{
		/*
		* bootstrap
		*/

		session_cache_limiter("private_no_expire");

		header("Cache-Control: no-store, no-cache, must-revalidate");
		header("Content-Type: text/html; charset=utf-8;");

		error_reporting(0);

		date_default_timezone_set('Europe/Warsaw');

		set_include_path('.' . PATH_SEPARATOR . 'cms/library' . PATH_SEPARATOR . get_include_path());
		set_include_path('.' . PATH_SEPARATOR . 'php/modules' . PATH_SEPARATOR . get_include_path());

		include "Zend/Loader.php";
		Zend_Loader::registerAutoload();

		$config = new Zend_Config_Ini ('./cms/config/config.ini', 'glowne');
		$configBaza = new Zend_Config_Ini ('./cms/config/config.ini', 'baza');
		$registry = Zend_Registry::getInstance();


		$db = Zend_Db::factory($configBaza->db->adapter, $configBaza->db->config->toArray());
		Zend_Db_Table::setDefaultAdapter($db);

		$db->query('SET NAMES utf8');
		$db->query('SET CHARACTER SET utf8');

		$registry->set('db', $db);
		$registry->set('config', $config);
		$registry->set('configBaza', $configBaza);

		include_once('Smarty/Smarty.class.php');

		$tpl = new Smarty;
		$tpl->template_dir = './templates/';
		$tpl->compile_dir = './templates_c/';

		$tpl->register_modifier('ss', 'stripslashes');
		$tpl->register_modifier('url', 'Index::toPermalink');

		$registry->set('tpl', $tpl);

		$this->getContent();
	}

	public static function przechwyc_blad($e)
	{
		$smarty = Zend_Registry::get('tpl');

		$smarty->assign('nr',$e->getCode());
		$smarty->assign('msg',$e->getMessage());

		echo $e->getMessage();
	}

	function randomString($length){
		static $srand;
		$result = '';
		if($srand != true){
			$srand = true;
			srand((double)microtime()*1000000);
		}
		$chars = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
		for($i=0; $i<$length; $i++){
			$result .= substr($chars,rand(0,strlen($chars)-1),1);
		}
		return $result;
	}


	private function authentication($login,$password) {
		$filtr = new Zend_Filter_StripTags();
		$login = $filtr->filter($login);
		$password = md5($filtr->filter($password));
		$db = Zend_Registry::get('db');
		$I = $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."users WHERE nazwa = '$login' AND haslo='$password'");

		if(!empty($I)){
			$_SESSION['user'] = $I;
			return true;
		}
		else {
			return false;
		}
	}

	private function check_mail_syntax($email)
	{
		$to_work_out = explode("@", $email);
		if (!isset($to_work_out[0])) return FALSE;
		if (!isset($to_work_out[1])) return FALSE;

		$pattern_local =  '^([0-9a-z]*([-|_]?[0-9a-z]+)*)(([-|_]?)\.([-|_]?)[0-9a-z]*([-|_]?[0-9a-z]+)+)*([-|_]?)$';
		$pattern_domain = '^([0-9a-z]+([-]?[0-9a-z]+)*)(([-]?)\.([-]?)[0-9a-z]*([-]?[0-9a-z]+)+)*\.[a-z]{2,4}$';
		$match_local = eregi($pattern_local, $to_work_out[0]);
		$match_domain = eregi($pattern_domain, $to_work_out[1]);

		if ($match_local && $match_domain) {
			return TRUE;
		}
		return FALSE;
	}

	private function checkEmpty($string){
		$string = str_replace(' ','',$string);
		$string = strip_tags($string);
		if(strlen($string) > 0)
		return false;
		return true;
	}

	function getSettings(){
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

		return $db->fetchRow("SELECT * FROM ".Index::dbPrefiks."meta WHERE id = 1");

	}
	
	public function getContent()
	{
		$db = Zend_Registry::get('db');
		$tpl = Zend_Registry::get('tpl');

        if(!isset($_SESSION['language']))
			$_SESSION['language'] = 'pl';
        $tpl->assign('langs',$_SESSION['language']);
		
		$id = 0;
		include_once 'kategorie/classKategorie.php';
		include_once 'tresc/classTresc.php';
		include_once 'files/class.files.php';
		include_once 'newsy/classAktualnosci.php';
		include_once 'gallery/classGalerie.php';
        include_once 'produkty/classProdukty.php';
        include_once 'seo/class.seo.php';
        include_once './inc/pagination.class.php';
        include_once 'language.php';
        include_once 'linki/classLinki.php';
		
		$content 	= new Strony();
		$cat		= new Kategorie();
		$news 		= new Aktualnosci();
		$gal 		= new Galerie();
		$file 		= new Files();
		$pg 		= new pagination;
		$seo 		= new Seo();
		$prod 		= new Produkty();
		$linki		= new Linki();

		$tpl->assign('lang', $text[$_SESSION['language']]);

		$tpl->assign('set',$this->getSettings());
		$tpl->assign('menu',$cat->getMenu(1));
		
		// print("<pre>");
		// print_r($cat->getMenu(1));
		// print("</pre>");
		

        if(isset($_GET['site']))
			$strona=$_GET['site'];
		else
			$strona=0;
			
		$tpl->assign('strona',$strona);
        
//       	print("<pre>");
//		print_r($temp);
//		print("</pre>");

		
//		$loga=$this->czytaj_katalog('img/logotypes', true);
//		shuffle($loga);
//		$tpl->assign('loga', $loga);
		
		switch($strona){
			case 1:		// podstrony tekstowe
				if(isset($_GET['name']))
				{
					$category=$cat->getCatByURL($_GET['name']);
					$tresc=reset($content->getContentCat($category['id']));
				}
				else
					$tresc=array('tytul'=>'Błąd', 'tresc'=>'Niepoprawny adres!');
				$tpl->assign('tresc', $tresc);
				$tpl->assign('include','text.tpl');
			break;
			case 2:		// kontakt
				if(isset($_SESSION['msg']))
				{
					$tpl->assign('informacja', $_SESSION['msg']);
					unset($_SESSION['msg']);
				}
				if(isset($_SESSION['err']))
				{
					$tpl->assign('badForm', $_SESSION['badForm']);
					$tpl->assign('informacja', $_SESSION['err']);
				}
				unset($_SESSION['err']);
				unset($_SESSION['ok']);
				unset($_SESSION['badForm']);
//				$category=$cat->getCatByURL('firma');
//				$category['submenu']=$cat->getMenu($category['id']);
				$tpl->assign('tresc', reset($content->getContentCat(35)));
				$tpl->assign('include','kontakt.tpl');
			break;
			case 3:		// oferta
				//print("<pre>");
				//print_r($prod->getAllProdukty());
				//print("--------------------------------------</pre>");
				//$tpl->assign('tresc', reset($content->getContentCat(24)));
				$tpl->assign('produkty', $prod->getAllProdukty());
				$tpl->assign('include', 'oferta.tpl');
			break;
			case 4:		// produkt
				if(isset($_GET['id']))
				{
					$tpl->assign('produkt', $prod->getProduktOnes($_GET['id']));
					$tpl->assign('produkty', $prod->getAllProdukty());
					$tpl->assign('zdjecia', $gal->getZdjecia($_GET['id']));
					$tpl->assign('include', 'produkt.tpl');
				}
			break;
			case 5:		//galeria
				$tpl->assign('tresc', reset($content->getContentCat(36)));
				$tpl->assign('zdjecia', $gal->getZdjeciaAll('X'));
				$tpl->assign('include','galeria.tpl');
			break;
/*			case 6:		// zapytanie ofertowe
				if(isset($_SESSION['msg']))
				{
					$tpl->assign('informacja', $_SESSION['msg']);
					unset($_SESSION['msg']);
				}
				if(isset($_SESSION['err']))
				{
					$tpl->assign('informacja', $_SESSION['err']);
				}
				unset($_SESSION['err']);
				unset($_SESSION['ok']);
				$tpl->assign('tresc', reset($content->getContentCat(26)));
				$tpl->assign('include', 'zapytanie.tpl');
			break;
*/
			case 333:
			    switch($_GET['lang']){
			     	case 'fr':
			      		$_SESSION['language'] = 'fr';
			      		break;
			     	case 'de':
			      		$_SESSION['language'] = 'de';
			      	break;
			     	case 'ru':
			     		$_SESSION['language'] = 'ru';
			     	break; 
			     	case 'en':
			     		$_SESSION['language'] = 'en';
			     	break;
			     	default:
			      		$_SESSION['language'] = 'pl';
			      	break;
			    }
				$requested_URI=explode('/', $_SERVER['HTTP_REFERER']);
//					 print("<pre>");
//					 print_r($requested_URI);
//					 print("--------------------------------------</pre>");
				if(strstr($requested_URI[count($requested_URI)-1], '.html') && !empty($requested_URI[count($requested_URI)-1]) && $requested_URI[count($requested_URI)-1]!='index.html')
				{
					$reguested_file=str_replace('.html', '', $requested_URI[count($requested_URI)-1]);
					if(strpos($reguested_file, ','))
					{
						$reguested_file=str_split($reguested_file, strpos($reguested_file, ','));
						$category=$cat->getCatByURL($reguested_file[0]);
						$requested_URI[count($requested_URI)-1]=$category['url_'.$_GET['lang']].$reguested_file[1].'.html';
					}
					else
					{
						$reguested_file=str_replace('.html', '', $requested_URI[count($requested_URI)-1]);
						$category=$cat->getCatByURL($reguested_file);
						$requested_URI[count($requested_URI)-1]=$category['url_'.$_GET['lang']].'.html';
					}
					
				}
//					 print("<pre>");
//					 print_r($requested_URI);
//					 print("--------------------------------------</pre>");
                header('Location: '.implode('/', $requested_URI));
			break;
			default:
				$oferta=$prod->getAllProdukty();
				$ofertaCount=count($oferta);
/*					 print("<pre>");
					 print_r($oferta);
					 print("\n offset: ".$ofertaCount." \n");
					 print("--------------------------------------\n");
					 $temp=(ceil($ofertaCount/2));
					 print("offset: 0 length: ".$temp." \n");
					 print_r(array_slice($oferta, 0, $temp));
					 print("--------------------------------------\n");
					 $temp=ceil($ofertaCount/2);
					 $temp2=$ofertaCount-(ceil($ofertaCount/2));
					 print("offset: ".$temp." length: ".$temp2." \n");
					 print_r(array_slice($oferta, $temp, $temp2));
					 print("--------------------------------------</pre>");
*/
				$tpl->assign('oferta1', array_slice($oferta, 0, (ceil($ofertaCount/2))));
				$tpl->assign('oferta2', array_slice($oferta, ceil($ofertaCount/2), $ofertaCount-(ceil($ofertaCount/2))));
				$tpl->assign('kontakt', reset($content->getContentCat(35)));
				$tpl->assign('firma', reset($content->getContentCat(33)));
				$tpl->assign('home', TRUE);
				$tpl->assign('include', 'start.tpl');
			break;
		}/* end switch */
        //$tpl->assign('let_error','');
        
		$requested_URI=explode('/', $_SERVER['REQUEST_URI']);
		//			 print("<pre>");
		//			 print_r(str_replace('.html', '', $requested_URI[count($requested_URI)-1]));
		//print_r($_SERVER);

		//print("--------------------------------------</pre>");
		$tpl->assign('aktywna_strona', str_replace('.html', '', $requested_URI[count($requested_URI)-1]));
		$tpl->display('index.tpl');


	}
	
	function rss_to_array($tag, $array, $url)
	{
		$doc = new DOMdocument();
        $doc->load($url);
        $rss_array = array();
        $items = array();
        foreach($doc->getElementsByTagName($tag) AS $node)
        {    
        	foreach($array AS $key => $value) 
        	{
        		$items[$value] = $node->getElementsByTagName($value)->item(0)->nodeValue;
            }
            array_push($rss_array, $items);
        }
		return $rss_array;
	}

	public static function toPermalink($string)
	{


		$unPretty = array('/ä/', '/ö/', '/ü/', '/Ä/', '/Ö/', '/Ü/', '/ß/',
		'/ą/', '/Ą/', '/ć/', '/Ć/', '/ę/', '/Ę/', '/ł/', '/Ł/' ,'/ń/', '/Ń/', '/ó/', '/Ó/', '/ś/', '/Ś/', '/ź/', '/Ź/', '/ż/', '/Ż/',
		'/Š/','/Ž/','/š/','/ž/','/Ÿ/','/Ŕ/','/Á/','/Â/','/Ă/','/Ä/','/Ĺ/','/Ç/','/Č/','/É/','/Ę/','/Ë/','/Ě/','/Í/','/Î/','/Ď/','/Ń/',
		'/Ň/','/Ó/','/Ô/','/Ő/','/Ö/','/Ř/','/Ů/','/Ú/','/Ű/','/Ü/','/Ý/','/ŕ/','/á/','/â/','/ă/','/ä/','/ĺ/','/ç/','/č/','/é/','/ę/',
		'/ë/','/ě/','/í/','/î/','/ď/','/ń/','/ň/','/ó/','/ô/','/ő/','/ö/','/ř/','/ů/','/ú/','/ű/','/ü/','/ý/','/˙/',
		'/Ţ/','/ţ/','/Đ/','/đ/','/ß/','/Œ/','/œ/','/Ć/','/ć/','/ľ/');

		$pretty   = array('ae', 'oe', 'ue', 'Ae', 'Oe', 'Ue', 'ss',
		'a', 'A', 'c', 'C', 'e', 'E', 'l', 'L', 'n', 'N', 'o', 'O', 's', 'S', 'z', 'Z', 'z', 'Z',
		'S','Z','s','z','Y','A','A','A','A','A','A','C','E','E','E','E','I','I','I','I','N',
		'O','O','O','O','O','O','U','U','U','U','Y','a','a','a','a','a','a','c','e','e','e',
		'e','i','i','i','i','n','o','o','o','o','o','o','u','u','u','u','y','y',
		'TH','th','DH','dh','ss','OE','oe','AE','ae','u');

		$permalink = strtolower(preg_replace($unPretty, $pretty, $string));
		return  str_replace(" ", "-", preg_replace("/[^a-zA-Z0-9 ]/", "", $permalink) );

	}

	public static function pathToNode($id,$s='1')
	{
		$db = Zend_Registry::get('db');

		if(!empty($id))
		{
			$sql = "SELECT lleft, rright FROM cms_drzewko WHERE id=".(int)$id;
			$results = $db->fetchAll($sql);

			if(!empty($results))
			{
				$sql = "SELECT * FROM cms_drzewko WHERE lleft <=".$results[0]['lleft']." AND rright >=".$results[0]['rright']." ORDER BY id";
				$results = $db->fetchAll($sql);

				$countResults = count($results);

				$path = null;
				$tab = array();

				for($i=0;$i<$countResults;$i++)
				{
					if($results[$i]['id']==1) $path .= '';
					else if($results[$i]['parent_id']==1) $path .= '';

					else $tab[$i]= ucfirst($results[$i]['nazwa']);
				}

				$path = join(' / ',$tab);
			}
		}

		else $path ='';

		return $path;

	}

        public static function usun_ogonki($str)
	{
		$trans = array(
						"Ą" => "a", "ą" => "a", "Ć" => "c", "ć" => "c", "Ę" => "e",
						"ę" => "e", "Ł" => "l", "ł" => "l", "Ó" => "o","ó" => "o",
						"Ń" => "n","ń" => "n","Ś" => "s","ś"=> "s","Ź" => "z",
						"ź"=> "z","Ż" => "z","ż" => "z","," => "");

		return strtr($str, $trans);
	}
	
	function czytaj_katalog($sciezka, $szczegoly)
	{
		$uchwyt = opendir($sciezka);
		while($plik = readdir($uchwyt))
		{
			if($plik!="." && $plik!="..")
			{
				if(is_dir($sciezka."/".$plik))
					$pliki[$plik]=czytaj_katalog($sciezka.'/'.$plik, $szczegoly);
				else
				{
					if($szczegoly)
					{
						$wymiary = getimagesize($sciezka.'/'.$plik);
						$pliki[] = array('nazwa' => $plik, 'szerokosc' => $wymiary[0], 'wysokosc' => $wymiary[1]);
					}
					else 
						$pliki[] = $plik;
				}
			}
		}
		closedir($uchwyt);
		//natsort($pliki);
		return $pliki;
	}
}
?>